/*
 * @(#)JHTMLPad.java  1.0  24. Februar 2006
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.html;

import javax.swing.*;
import javax.swing.text.html.*;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * JHTMLPad.
 *
 * @author Werner Randelshofer
 * @version 1.0 24. Februar 2006 Created.
 */
public class JHTMLPad extends javax.swing.JPanel {
        private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch/randelshofer/html/Labels");
    
    /** Creates new form. */
    public JHTMLPad() {
        
        initComponents();
        editor.setEditorKit(new HTMLEditorKit());
        
       
        
        addActionsTo(new String[] {
            "InsertHR",
            "InsertOrderedList", "InsertOrderedListItem",
            "InsertUnorderedList", "InsertUnorderedListItem",
            "InsertTable", "InsertTableDataCell", "InsertTableRow",
            "InsertPre",
        }, insertToolBar);
        
        addActionsTo(new String[] {
            "font-bold", "font-italic", "font-underline",
            null,
            "left-justify", "center-justify", "right-justify",
        }, styleToolBar);
    }
    
    public JTextPane getEditor() {
        return editor;
    }
    
    public String getText() {
        return editor.getText();
    }
    public void setText(String text) {
        editor.setText(text);
    }
    
    private void addActionsTo(String[] names, JToolBar tb) {
        Action[] editorActions = editor.getActions();
        for (String name : names) {
            if (name == null) {
                tb.addSeparator();
            } else {
                for (Action action : editorActions) {
                    if (action.getValue(Action.NAME).equals(name)) {
                        JButton button = tb.add(action);
                        labels.configureButton(button, "html"+name);
                        button.setFocusable(false);
                        button.setText(null);
                        break;
                    }
                }
            }
        }
    }
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                JFrame f = new JFrame("JHTMLPad");
                f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                f.getContentPane().add(new JHTMLPad());
                f.setSize(400,400);
                f.setVisible(true);
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        insertToolBar = new javax.swing.JToolBar();
        jPanel1 = new javax.swing.JPanel();
        styleToolBar = new javax.swing.JToolBar();
        scrollPane = new javax.swing.JScrollPane();
        editor = new javax.swing.JTextPane();

        setLayout(new java.awt.BorderLayout());

        insertToolBar.setFloatable(false);
        add(insertToolBar, java.awt.BorderLayout.NORTH);

        jPanel1.setLayout(new java.awt.BorderLayout());

        styleToolBar.setFloatable(false);
        jPanel1.add(styleToolBar, java.awt.BorderLayout.NORTH);

        scrollPane.setViewportView(editor);

        jPanel1.add(scrollPane, java.awt.BorderLayout.CENTER);

        add(jPanel1, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextPane editor;
    private javax.swing.JToolBar insertToolBar;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JToolBar styleToolBar;
    // End of variables declaration//GEN-END:variables
    
}
